	/*
    * PDFFP Plugin for insert a PDF icon with this link in a article for Joomla! 3.x
    * Version J3_5
    * Creation date: Octobre 2016
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/
	
(function() {
var ImageManager = this.ImageManager = {
	initialize: function()
	{
		o = this._getUriObject(window.self.location.href);
		// console.log(o);
		q = new Hash(this._getQueryObject(o.query));
		this.editor = decodeURIComponent(q.get('e_name'));

		// Setup image manager fields object
		this.fields			= new Object();
		this.fields.url		= document.id("f_url");
		this.fields.alt		= document.id("f_alt");
		this.fields.align	= document.id("f_align");
		this.fields.title	= document.id("f_title");
		this.fields.caption	= document.id("f_caption");
		this.fields.affichage	= document.id("f_affichage");
		this.fields.hauteur	= document.id("f_hauteur");
		this.fields.largeur	= document.id("f_largeur");

		this.frame		= window.frames['imageframe'];
		this.frameurl	= this.frame.location.href;
	},

	onok: function()
	{
		extra = '';
		// Get the image tag field information
		var url		= this.fields.url.get('value');
		var alt		= this.fields.alt.get('value');
		var align	= this.fields.align.get('value');
		var title	= this.fields.title.get('value');
		var caption	= this.fields.caption.get('value');
		var affichage	= this.fields.affichage.get('value');
		var hauteur	= this.fields.hauteur.get('value');
		var largeur	= this.fields.largeur.get('value');

		if (url != '') {
			// Set alt attribute
			if (alt != '') {
				alt = ' alt="'+alt+'" ';
			} else {
				alt = ' alt="" ';
			}
			// Set align attribute
			if (align != '') {
				align = ' align="'+align+'" ';
			}
			// Set align attribute
			if (title != '') {
				title = title;
			} else if (alt != '') {
				title = alt;
			} else {
				title = 'PDF';			
			}
			var title_icon = ' title="'+title+'" ';
			// Set align attribute
			if (caption != '') {
				caption = 'class="caption" ';
			}
		// console.log(affichage);

			switch (parseInt(affichage)) {
				case 0: //icon pdf
					var tag = "<a href=\""+url+"\" target=\"_blank\"><img src=\"components/com_plugin_pdffp/icon_pdf.gif\" "+alt+align+title_icon+caption+extra+"/></a>";
					break;
				case 1: //link pdf
					var tag = "<a href=\""+url+"\" "+alt+" target=\"_blank\">"+title+"</a>";
					break;
				case 2: //encapsulation
					var tag = "<object data=\""+url+"\" type=\"application/pdf\" width=\""+largeur+"\" height=\""+hauteur+"\" >";
					tag = tag + "<p>It appears you don't have a PDF plugin for this browser. No biggie... you can <a href=\""+url+"\">click here to download the PDF file.</a></p>"
					tag = tag + "</object>";
					break;
			}
		}
		// console.log(tag);
		window.parent.jInsertEditorText(tag, this.editor);
		return false;
	},

	populateFields: function(file)
	{
		document.id("f_url").value = file;
	},

	_getQueryObject: function(q) {
		var vars = q.split(/[&;]/);
		var rs = {};
		if (vars.length) vars.each(function(val) {
			var keys = val.split('=');
			if (keys.length && keys.length == 2) rs[encodeURIComponent(keys[0])] = encodeURIComponent(keys[1]);
		});
		return rs;
	},

	_getUriObject: function(u){
		var bits = u.match(/^(?:([^:\/?#.]+):)?(?:\/\/)?(([^:\/?#]*)(?::(\d*))?)((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[\?#]|$)))*\/?)?([^?#\/]*))?(?:\?([^#]*))?(?:#(.*))?/);
		return (bits)
			? bits.associate(['uri', 'scheme', 'authority', 'domain', 'port', 'path', 'directory', 'file', 'query', 'fragment'])
			: null;
	}
};
})(document.id);

window.addEvent('domready', function(){
	ImageManager.initialize();
});
